<?php
// ====================================================================================
// SHORTCODE [report from="x" to="y" post="z"] – botón de reporte
// ====================================================================================
add_shortcode("report", function ($atts) {
    if (!is_user_logged_in()) {
        return "<div>Debes iniciar sesión para reportar.</div>";
    }

    $atts = shortcode_atts(array(
        "from" => 0,
        "to"   => 0,
        "post" => 0
    ), $atts, "report");

    $from    = intval($atts["from"]);
    $to      = intval($atts["to"]);
    $post_id = intval($atts["post"]);
    if ($from <= 0 || $to <= 0) {
        return "<div>Parámetros inválidos.</div>";
    }

    // Calculamos la clave del chat para que el server valide lo mismo
    $chat_key = esc_attr(soc_normalize_chat_key($from, $to));
    $ajax_url = esc_url(admin_url("admin-ajax.php"));

    ob_start();
    ?>
    <div class="soc-report-wrap" data-chat-key="<?php echo $chat_key; ?>" data-from="<?php echo $from; ?>" data-to="<?php echo $to; ?>" data-post="<?php echo $post_id; ?>" data-ajax="<?php echo $ajax_url; ?>">
        <button type="button" class="soc-report-btn"><img draggable="false" role="img" class="emoji" alt="⚠" src="https://s.w.org/images/core/emoji/16.0.1/svg/26a0.svg">&nbsp;Report this listing / user</button>
        <div class="soc-report-msg" style="margin-top:8px;"></div>
    </div>

    <script>
    // Usar jQuery como pides
    jQuery(document).ready(function ($) {
        // Click en el botón de reporte
        $(".soc-report-wrap .soc-report-btn").on("click", function () {
            // Contenedor
            var $wrap = $(this).closest(".soc-report-wrap");
            // Datos que enviaremos
            var payload = {
                action: "soc_report_chat",
                chat_key: $wrap.data("chat-key"),
                from: $wrap.data("from"),
                to: $wrap.data("to"),
                post_id: $wrap.data("post")
            };

            // Deshabilitar mientras enviamos
            $(this).prop("disabled", true);

            // Llamada Ajax
            $.post($wrap.data("ajax"), payload, function (res) {
                // Si el server respondió OK mostramos el mensaje y ocultamos el botón
                if (res && res.success == true) {
                    $wrap.find(".soc-report-msg").html("Thanks for your report, our team is investigating");
                    $("#message-listing").remove();
                    $wrap.find(".soc-report-btn").hide();
                } else {
                    // Si algo falla, re-habilitamos el botón para reintentar
                    $wrap.find(".soc-report-msg").html("No se pudo enviar tu reporte.");
                    $wrap.find(".soc-report-btn").prop("disabled", false);
                }
            }, "json");
        });
    });
    </script>
    <?php
    return ob_get_clean();
});
